--[[
IncreasedWorkAreasForPickups

Specialization for wider work areas on pickups, so it is easier to pick up the windrows, especially on turns

Author: 	Ifko[nator]
Date: 		17.03.2025
Version:	1.1

History:	v1.0 @03.12.2024 - initial implementation in FS 25
			---------------------------------------------------------------------------------------------------------------------------------------
			v1.1 @17.03.2025 - fix for Error: Running LUA method 'update'.
									   /FS25_increasedWorkAreasForPickups/IncreasedWorkAreasForPickups.lua:36: attempt to index nil with 'threshold'
]]

IncreasedWorkAreasForPickups = {};

IncreasedWorkAreasForPickups.modDirectory = g_currentModDirectory;

function IncreasedWorkAreasForPickups:workAreaOnLoad(savegame)
	local modDesc = loadXMLFile("modDesc", IncreasedWorkAreasForPickups.modDirectory .. "modDesc.xml");

	local workingWidth = MathUtil.round(Utils.getNoNil(getXMLFloat(modDesc, "modDesc.increasedWorkAreasForPickups#workingWidth"), 4) / 2, 2);

	delete(modDesc);

	for _, workArea in pairs(self.spec_workArea.workAreas) do
		if workArea.functionName == "processPickupCutterArea" --## forage harvester pickup
			or workArea.functionName == "processForageWagonArea" --## forage wagon
			or workArea.functionName == "processBalerArea" --## baler
		then	
			local _, workAreaStartY, workAreaStartZ = getTranslation(workArea.start);
			local _, _, workAreaHeightZ = getTranslation(workArea.height);

			for _, direction in pairs({"start", "width", "height"}) do
				if workArea[direction] ~= nil then
					local widthToSet = workingWidth;
					local zPosition = workAreaStartZ;

					if direction == "width" then
						widthToSet = -workingWidth;
					elseif direction == "height" then
						zPosition = workAreaHeightZ;
					end;

					setTranslation(workArea[direction], widthToSet, workAreaStartY, zPosition);
				end;
			end;

			if workArea.groundReferenceNode ~= nil then
				workArea.groundReferenceNode.threshold = workingWidth;
			end;
		end;
	end;
end;

WorkArea.onLoad = Utils.appendedFunction(WorkArea.onLoad, IncreasedWorkAreasForPickups.workAreaOnLoad);